/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.transport;

import java.io.IOException;
import java.util.Map;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.timeseries.model.Mergeable;
import org.opensearch.timeseries.transport.StatsNodesResponse;

public class StatsResponse
implements ToXContentObject,
Mergeable {
    private StatsNodesResponse statsNodesResponse;
    private Map<String, Object> clusterStats;

    public Map<String, Object> getClusterStats() {
        return this.clusterStats;
    }

    public void setClusterStats(Map<String, Object> clusterStats) {
        this.clusterStats = clusterStats;
    }

    public StatsNodesResponse getStatsNodesResponse() {
        return this.statsNodesResponse;
    }

    public void setStatsNodesResponse(StatsNodesResponse statsNodesResponse) {
        this.statsNodesResponse = statsNodesResponse;
    }

    public XContentBuilder toXContent(XContentBuilder builder) throws IOException {
        return this.toXContent(builder, ToXContent.EMPTY_PARAMS);
    }

    public StatsResponse() {
    }

    public StatsResponse(StreamInput in) throws IOException {
        this.statsNodesResponse = new StatsNodesResponse(in);
        this.clusterStats = in.readMap();
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.statsNodesResponse.writeTo(out);
        out.writeMap(this.clusterStats);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        XContentBuilder xContentBuilder = builder.startObject();
        for (Map.Entry<String, Object> clusterStat : this.clusterStats.entrySet()) {
            builder.field(clusterStat.getKey(), clusterStat.getValue());
        }
        this.statsNodesResponse.toXContent(xContentBuilder, ToXContent.EMPTY_PARAMS);
        return xContentBuilder.endObject();
    }

    @Override
    public void merge(Mergeable other) {
        if (this == other || other == null || this.getClass() != other.getClass()) {
            return;
        }
        StatsResponse otherResponse = (StatsResponse)other;
        if (otherResponse.statsNodesResponse != null) {
            this.statsNodesResponse = otherResponse.statsNodesResponse;
        }
        if (otherResponse.clusterStats != null) {
            this.clusterStats = otherResponse.clusterStats;
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StatsResponse other = (StatsResponse)obj;
        return new EqualsBuilder().append((Object)this.statsNodesResponse, (Object)other.statsNodesResponse).append(this.clusterStats, other.clusterStats).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.statsNodesResponse).append(this.clusterStats).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("statsNodesResponse", (Object)this.statsNodesResponse).append("clusterStats", this.clusterStats).toString();
    }
}

