"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerObservabilityUISettings = void 0;
var _configSchema = require("@osd/config-schema");
var _i18n = require("@osd/i18n");
var _ui_settings = require("../../../../src/core/server/ui_settings");
var _trace_analytics = require("../../common/constants/trace_analytics");
var _apm = require("../../common/constants/apm");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const registerObservabilityUISettings = uiSettings => {
  uiSettings.register({
    [_trace_analytics.TRACE_CUSTOM_SPAN_INDEX_SETTING]: {
      name: _i18n.i18n.translate('observability.traceAnalyticsCustomSpanIndices.name', {
        defaultMessage: 'Trace analytics span indices'
      }),
      value: _trace_analytics.DATA_PREPPER_INDEX_NAME,
      category: ['Observability'],
      description: _i18n.i18n.translate('observability.traceAnalyticsCustomSpanIndices.description', {
        defaultMessage: 'Configure span indices that adhere to Data Prepper schema, to be used by the trace analytics plugin'
      }),
      schema: _configSchema.schema.string()
    }
  });
  uiSettings.register({
    [_trace_analytics.TRACE_CUSTOM_SERVICE_INDEX_SETTING]: {
      name: _i18n.i18n.translate('observability.traceAnalyticsCustomServiceIndices.name', {
        defaultMessage: 'Trace analytics service indices'
      }),
      value: _trace_analytics.DATA_PREPPER_SERVICE_INDEX_NAME,
      category: ['Observability'],
      description: _i18n.i18n.translate('observability.traceAnalyticsCustomServiceIndices.description', {
        defaultMessage: 'Configure service indices that adhere to Data Prepper schema, to be used by the trace analytics plugin'
      }),
      schema: _configSchema.schema.string()
    }
  });
  uiSettings.register({
    [_trace_analytics.TRACE_CUSTOM_MODE_DEFAULT_SETTING]: {
      name: _i18n.i18n.translate('observability.traceAnalyticsCustomModeDefault.name', {
        defaultMessage: 'Trace analytics default mode'
      }),
      value: false,
      category: ['Observability'],
      description: _i18n.i18n.translate('observability.traceAnalyticsCustomModeDefault.description', {
        defaultMessage: 'Enable this to default to Data Prepper mode in the trace analytics plugin'
      }),
      schema: _configSchema.schema.boolean()
    }
  });
  uiSettings.register({
    [_trace_analytics.TRACE_CORRELATED_LOGS_INDEX_SETTING]: {
      name: _i18n.i18n.translate('observability.traceAnalyticsCorrelatedLogsIndices.name', {
        defaultMessage: 'Trace analytics correlated logs indices'
      }),
      value: _trace_analytics.DEFAULT_SS4O_LOGS_INDEX,
      category: ['Observability'],
      description: _i18n.i18n.translate('observability.traceAnalyticsCorrelatedLogsIndices.description', {
        defaultMessage: 'Configure correlated logs indices, to be used by the trace analytics plugin to correlate spans and services to logs'
      }),
      schema: _configSchema.schema.string()
    }
  });
  uiSettings.register({
    [_trace_analytics.TRACE_LOGS_FIELD_MAPPNIGS_SETTING]: {
      name: _i18n.i18n.translate('observability.traceAnalyticsCorrelatedLogsFieldMappings.name', {
        defaultMessage: 'Trace analytics correlated logs fields'
      }),
      value: _trace_analytics.DEFAULT_CORRELATED_LOGS_FIELD_MAPPINGS,
      category: ['Observability'],
      description: _i18n.i18n.translate('observability.traceAnalyticsCorrelatedLogsFieldMappings.description', {
        defaultMessage: 'Configure correlated logs fields, to be used by the trace analytics plugin for correlate spans and services to logs'
      }),
      schema: _configSchema.schema.object({
        serviceName: _configSchema.schema.string(),
        spanId: _configSchema.schema.string(),
        timestamp: _configSchema.schema.string(),
        traceId: _configSchema.schema.string()
      })
    }
  });
  uiSettings.register({
    [_trace_analytics.TRACE_SERVICE_MAP_MAX_NODES]: {
      name: _i18n.i18n.translate('observability.traceAnalyticsServiceMapMaxNodes.name', {
        defaultMessage: 'Trace analytics service map maximum nodes'
      }),
      value: _trace_analytics.DEFAULT_SERVICE_MAP_MAX_NODES,
      category: ['Observability'],
      description: _i18n.i18n.translate('observability.traceAnalyticsServiceMapMaxNodes.description', {
        defaultMessage: 'Set the maximum number of nodes that the trace analytics plugin should request for rendering of service maps'
      }),
      schema: _configSchema.schema.number({
        min: 1
      })
    }
  });
  uiSettings.register({
    [_trace_analytics.TRACE_SERVICE_MAP_MAX_EDGES]: {
      name: _i18n.i18n.translate('observability.traceAnalyticsServiceMapMaxEdges.name', {
        defaultMessage: 'Trace analytics service map maximum edges'
      }),
      value: _trace_analytics.DEFAULT_SERVICE_MAP_MAX_EDGES,
      category: ['Observability'],
      description: _i18n.i18n.translate('observability.traceAnalyticsServiceMapMaxEdges.description', {
        defaultMessage: 'Set the maximum number of edges that the trace analytics plugin should request for rendering of service maps'
      }),
      schema: _configSchema.schema.number({
        min: 1
      })
    }
  });

  // APM Feature Toggle - requires Discover Traces to be enabled
  uiSettings.register({
    [_apm.APM_ENABLED_SETTING]: {
      name: _i18n.i18n.translate('observability.apmEnabled.name', {
        defaultMessage: 'Enable APM'
      }),
      value: true,
      category: ['Observability'],
      description: _i18n.i18n.translate('observability.apmEnabled.description', {
        defaultMessage: 'Enable the APM (Application Performance Monitoring) feature. When enabled and the Discover Traces feature is active, APM Services and Application Map pages are available in the navigation. Otherwise, Trace Analytics pages are shown as fallback.'
      }),
      schema: _configSchema.schema.boolean(),
      requiresPageReload: true,
      scope: _ui_settings.UiSettingScope.GLOBAL
    }
  });
};
exports.registerObservabilityUISettings = registerObservabilityUISettings;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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