/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.notifications.core.repackage.org.apache.hc.client5.http.entity.compress;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.HttpEntity;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.http.io.entity.HttpEntityWrapper;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.io.IOFunction;
import org.opensearch.notifications.core.repackage.org.apache.hc.core5.util.Args;

public class DecompressingEntity
extends HttpEntityWrapper {
    private static final int BUF_SIZE = 8192;
    private final IOFunction<InputStream, InputStream> decoder;
    private volatile InputStream cached;

    public DecompressingEntity(HttpEntity src, IOFunction<InputStream, InputStream> decoder) {
        super(src);
        this.decoder = Args.notNull(decoder, "Stream decoder");
    }

    @Override
    public InputStream getContent() throws IOException {
        if (!this.isStreaming()) {
            return this.decoder.apply(super.getContent());
        }
        InputStream local = this.cached;
        if (local == null) {
            if (this.cached == null) {
                this.cached = this.decoder.apply(super.getContent());
            }
            local = this.cached;
        }
        return local;
    }

    @Override
    public long getContentLength() {
        return -1L;
    }

    @Override
    public String getContentEncoding() {
        return null;
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        Args.notNull(out, "Output stream");
        try (InputStream in = this.getContent();){
            int len;
            byte[] buf = new byte[8192];
            while ((len = in.read(buf)) != -1) {
                out.write(buf, 0, len);
            }
        }
    }
}

