/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.agent;

import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ml.common.agent.MLAgentModelSpec;
import org.opensearch.ml.common.connector.Connector;
import org.opensearch.ml.common.input.execute.agent.ModelProviderType;
import org.opensearch.ml.common.model.ModelProvider;
import org.opensearch.ml.common.model.ModelProviderFactory;
import org.opensearch.ml.common.transport.register.MLRegisterModelInput;

public class AgentModelService {
    @Generated
    private static final Logger log = LogManager.getLogger(AgentModelService.class);

    public static MLRegisterModelInput createModelFromSpec(MLAgentModelSpec modelSpec) {
        AgentModelService.validateModelSpec(modelSpec);
        ModelProvider provider = ModelProviderFactory.getProvider(modelSpec.getModelProvider());
        Connector connector = provider.createConnector(modelSpec.getModelId(), modelSpec.getCredential(), modelSpec.getModelParameters());
        return provider.createModelInput(modelSpec.getModelId(), connector, modelSpec.getModelParameters());
    }

    public static String inferLLMInterface(String modelProvider) {
        if (modelProvider == null) {
            return null;
        }
        try {
            ModelProvider provider = ModelProviderFactory.getProvider(modelProvider);
            return provider.getLLMInterface();
        }
        catch (Exception e) {
            log.error("Failed to infer LLM interface", (Throwable)e);
            return null;
        }
    }

    private static void validateModelSpec(MLAgentModelSpec modelSpec) {
        if (modelSpec == null) {
            throw new IllegalArgumentException("Model specification not found");
        }
        if (modelSpec.getModelId() == null || modelSpec.getModelId().trim().isEmpty()) {
            throw new IllegalArgumentException("model_id cannot be null or empty");
        }
        if (modelSpec.getModelProvider() == null || modelSpec.getModelProvider().trim().isEmpty()) {
            throw new IllegalArgumentException("model_provider cannot be null or empty");
        }
        ModelProviderType.from(modelSpec.getModelProvider());
    }
}

